import math
class HypothesisFilter(object):

  def __init__(self, tokens, log_probs, state, clazzes, scopes=[1], scope_index=1, current_scope=[1], last_scope=[1], control_apis=[], thenbodycontrol_apis=[], context_apis=[]):
    self.current_scope = current_scope
    self.last_scope = last_scope
    self.scope_index = scope_index
    self.tokens = tokens
    self.log_probs = log_probs
    self.state = state
    self.clazzes = []
    self.scopes = []
    self.control_apis = []
    self.context_apis = []
    self.thenbodycontrol_apis = []
    for api in context_apis:
      self.context_apis.append(api)
    for api in control_apis:
      if api == "if" or api == "for" or api == "while" or api == "doWhile" or api == "foreach":
        self.control_apis.append(api)
      elif api == "out_control":
        if len(self.control_apis) > 0:
          self.control_apis.pop()
      else:
        continue
    for api in thenbodycontrol_apis:
      if api == "if" or api == "elseif" or api == "for" or api == "while" or api == "doWhile" or api == "foreach":
        self.thenbodycontrol_apis.append(api)
      elif api == "then" or api == "body":
        if len(self.thenbodycontrol_apis) > 0:
          self.thenbodycontrol_apis.pop()
      else:
        continue
    for c in clazzes:
      self.clazzes.append(c)
    for s in scopes:
      self.scopes.append(s)
    while len(self.scopes) < len(self.clazzes):
      self.scopes.append(self.scopes[-1])

  def extend(self, token, log_prob, state, clazz, scopes, scope_index, current_scope, last_scope, control_api, thenbodycontrol_api, context_api):
    return HypothesisFilter(tokens = self.tokens + [token],
                      log_probs = self.log_probs + [log_prob],
                      state = state,
                      clazzes = self.clazzes + clazz.split(";"),
                      scopes = self.scopes + [scopes],
                      scope_index = scope_index,
                      current_scope = current_scope,
                      last_scope = last_scope,
                      control_apis = self.control_apis + [control_api],
                      thenbodycontrol_apis = self.thenbodycontrol_apis + [thenbodycontrol_api],
                      context_apis = self.context_apis + [context_api]
                      )
  @property
  def get_context_apis(self):
    return self.context_apis

  @property
  def get_scopes(self):
    return self.scopes
  @property
  def get_last_scope(self):
    return self.last_scope
  @property
  def get_cuurent_scope(self):
    return self.current_scope
  @property
  def get_scope_index(self):
    return self.scope_index
  @property
  def get_clazzes(self):
    return self.clazzes
  @property
  def latest_token(self):
    return self.tokens[-1]

  @property
  def get_log_probs(self):
    return self.log_probs

  @property
  def get_control_apis(self):
    return self.control_apis

  @property
  def get_thenbodycontrol_apis(self):
    return self.thenbodycontrol_apis

  @property
  def log_prob(self):
    sum_prob = 0
    for i in range(len(self.log_probs)):
      if i == 0:
        continue
      else:
        sum_prob += math.log(self.log_probs[i])
    return sum_prob

  @property
  def avg_log_prob(self):
    return self.log_prob / ((len(self.tokens) - 1))


  @property
  def get_tokens(self):
      return self.tokens